/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.login;

import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.fw.connmgr.ConnectionFactory;
import com.ibm.hwmca.fw.servlet.login.BobcatHmcPrincipal;
import com.ibm.hwmca.fw.servlet.util.ServletRuntime;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BobcatLogin
extends HttpServlet {
    private static final String TRACE_MASKF = "XLGNSRVF";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Trace.trace(TRACE_MASKF, "-> BobcatLogin.doGet");
        resp.setHeader("Cache-Control", "no-cache");
        ServletRuntime.initializeWebApplication(req, this.getServletContext());
        boolean processingError = this.getInitParameter("errorPage") != null;
        String username = req.getParameter("j_username");
        String password = req.getParameter("j_password");
        if (username != null && password != null) {
            try {
                Trace.trace(TRACE_MASKF, "BobcatLogin: creating connection factory");
                ConnectionFactory connFactory = new ConnectionFactory(CommonSystem.getCommonSystem().getManagerHost(), 9940);
                connFactory.setUserAndPassword(username, CommonSystem.getCommonSystem().hashPassword(password.toUpperCase()));
                Trace.trace(TRACE_MASKF, "BobcatLogin: authenticated.. setting principal");
                BobcatHmcPrincipal principal = new BobcatHmcPrincipal(username, connFactory);
                req.getSession().setAttribute("PRINCIPAL", (Object)principal);
                resp.sendRedirect(resp.encodeRedirectURL("/hmc/connect"));
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, e);
                resp.sendRedirect(resp.encodeRedirectURL("/hmc/login.jsp?errorPage=1"));
            }
        } else {
            String key;
            Trace.trace(TRACE_MASKF, "BobcatLogin: no username/pass provided.. forwarding to login.jsp");
            try {
                byte[] xcpxStatus = SimServer.getSimServer().readSim(5);
                key = xcpxStatus[0] == 1 ? "title_se" : "title";
            }
            catch (Exception e) {
                key = "title";
            }
            req.setAttribute("title_key", (Object)key);
            Trace.trace(TRACE_MASKF, "Dispatching login " + (processingError ? "error " : "") + "request to login.jsp");
            req.getRequestDispatcher("/login.jsp").forward((ServletRequest)req, (ServletResponse)resp);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

